#pragma warning (disable:4786) 

#include <vector>

struct sort_set{
	int m_index;
	double m_value;
	std::vector<double> m_aryParamters;
};

struct model_input {
	std::vector<double> m_aryTestParameters;				// default parameter for creating true data for test
	std::vector<int> m_aryLocationOfOptParameter;			// index of optimized parameter
	std::vector<std::string> m_aryDate;						// time 
	std::vector< std::vector<double> > m_aryInputData;		// input data [record num.][input data index]
	std::vector< std::vector<double> > m_aryObsData;		// observed data
};

class CSCE_UA
{
	// M.Ueyama (2014.06.16)
public:
	CSCE_UA(double m_dErrorValue);

	// parameters for conducting SCE-UA	
	int m_maxn;				// IƂĖړI֐vZ񐔂̏
	int m_kstop;			// m_dEpsPercent ŏIŒ̍킹
	double m_dEpsPercent;	// I̖ړI֐ʕω
	int m_ngs;				// RvbNXO[v
	int m_nopt;				// p[^̐
	
	int m_npg;				// eRvbNXO[vł̌l	 (2ȏA{ݒ NPG = 3 * p^ + 1)
	int m_nps;				// TuRvbNXƂł̌l (NSP = p^ + 1)
	int m_nspl;				// eRvbNXO[vł̌li񐔁@({ݒNSPL = NPG)
	int m_mings;			// RvbNXO[v̍Œl ({ݒMINGS = NGS)
	int m_iniflg;			// 3sڈȍ~̃p^l͑I@(0͏lpȂA1͏lp)
	int m_iprint;			// œKvZʂ̃vgIvV (0͊e킹̌㏇1̂ݏóA1ׂ͂Ă̌ľʂo)

	int m_npar;				// f̃p^
	int m_ndata;			// ړI֐vZŗpϑʃf[^̐
	int m_iobj;				// ړI֐̑I (1: SLS, 2: HMLE, 3:NSE, 4: RMSE)
	int m_idata;			// ϑf[^̊pI (0: ϑf[^gpA 1: ݒp^pčf[^쐬ϑlƂ)

	int m_iRecordNum;		// ϑf[^̐

	int m_iseed;
	double m_dErrorValue;	// NXgpɂُl

	int m_iOptimizedPrm;	// œK鍀ڔԍ

	std::vector<double> m_aryIniPrm;			// array for initial value of target paramameter
	std::vector<double> m_aryLowPrm;			// array for lower boudary of parameter space
	std::vector<double> m_aryHighPrm;			// array for upper boudary of parameter space
	std::vector<double> m_aryLowPrmDefault;		// array for lower boudary of parameter space
	std::vector<double> m_aryHighPrmDefault;	// array for upper boudary of parameter space
	std::vector<double> m_aryBestPrm;			// array for best parameter space
	double m_dBestFunc;

	std::vector<int> m_jseed;

	void create_random_seed_defualt(int nrun, bool bUseTime = false);
	void set_default_sce_parameters(int nopt, int ngs);
	bool sceua(model_input& cModel, const char strOutFile[], int iCurrentNumber, 
		void (*model_func) (std::vector<double>& , const std::vector< std::vector<double> >& ,  std::vector< std::vector<double> >&) );

	
private:
	void cce(std::vector< std::vector<double> >& s, std::vector<double>& sf, 
		 std::vector<double>& xnstd, int icall, int iseed, model_input& cModel, 
		 void (*model_func) (std::vector<double>& , const std::vector< std::vector<double> >& ,  std::vector< std::vector<double> >&));
	double functn(const int& nopt, const int& npar, const int& iobj,
			  std::vector< std::vector<double> >& obsq, std::vector<double>& x, std::vector< std::vector<double> >& p, std::vector<double>& pt, std::vector<int>& loc,
			  void (*model_func) (std::vector<double>& , const std::vector< std::vector<double> >& ,  std::vector< std::vector<double> >&) );
	double max(double iA, double iB);
	double min(double iA, double iB);
	double rand_normal();
	double rand_Gaussian_dev(int&);
	void chkcst(int , double& , double& , double& , int& );
	void chkcst(int nopt, std::vector<double>& x, std::vector<double>& bl, std::vector<double>& bu, int& ibound);
	void sort_sce(int , int , std::vector< std::vector<double> >& , std::vector<double>& );
	void sort_sce(int , std::vector<int>& );
	static bool compare(const sort_set &s1, const sort_set &s2) ;
	void get_point(int& , int , int& , std::vector<double>& , std::vector<double>& , std::vector<double>& , std::vector<double>& ,std:: vector<double>& );
	void parstt(int , int , std::vector< std::vector<double> >& , std::vector<double>& , std::vector<double>& , double& , int& );
	void comp(int , int , int , int , int , std::vector< std::vector<double> >& , std::vector<double>& , std::vector< std::vector<double> >& , std::vector<double>& );
};