// LeafPhotosynthesis.h: CLeafPhotosynthesis NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LEAFPHOTOSYNTHESIS_H__05A32DE7_A75E_41ED_A806_3C6D57364F83__INCLUDED_)
#include<vector>
#define AFX_LEAFPHOTOSYNTHESIS_H__05A32DE7_A75E_41ED_A806_3C6D57364F83__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CLeafPhotosynthesis  
{
public:
	CLeafPhotosynthesis(double dErrorValue);
	virtual ~CLeafPhotosynthesis();

	void SetParameter(const double& dVcmax25, const double& dJmax25, const double& dOmega, const double& dM, const double& dB);
	void SetParameter(const double& dVcmax25, const double& dJmax25, const double& dOmega, const double& dM, const double& dB, const double& dD0);
	void Farquhar_BigLeaf(const double& dCO2, double dPPFD, const double& dAirTemperature, double dLeafTemperature, 
		const double& dVPD_air, const double& dVP_air, const double& dVP_leaf, const double& dPressure, const double& dGc, double dGb, const double& dTg, const double& dUpscalingFactor,
		const double& dLAI, const double& dPPFD_direct, const double& dPPFD_diffuse, const double& dKb, const double& dKb2, const double& dRow_cb, const double& dRow_cd);
	void Farquhar_BigLeaf(const double& dCO2, double dPPFD, const double& dAirTemperature, double dLeafTemperature, const double& dVPD_air, const double& dVP_air, const double& dVP_leaf, const double& dPressure, const double& dGc, double dGb, const double& dTg, const double& dUpscalingFactor);
	void Stomatal_conductance_Ball_Berry(const double& dCO2, const double& dPPFD, const double& dGPP, double dLeafTemperature, const double& dVPD_air, const double& dVP_air, const double& dVP_leaf, const double& dPressure, const double& dGc, double dGb, const double& dTg, const double& dUpscalingFactor);

	void photosynthesis_model_C4(double& dAn, const double& dCO2, const double& dPPFD, const double& dT_leaf, const double& dRhs, const double& dPressure, const double& dUpscalingFactor);
	
	void Farquhar_BigLeaf_coupled_EB(const double& dCO2, double dPPFD, const double& dAirTemperature, double& dLeafTemperature, 
		const double& dVPD_air, const double& dVP_air, const double& dVP_leaf, const double& dPressure, const double& dGc, double dGb,
		const double& dH, const double& dLE, const double& dG, const double& dT_air, const double& dTg, const double& dRamda, const double& dUpscalingFactor,
		const double& dLAI, const double& dPPFD_direct, const double& dPPFD_diffuse, const double& dKb, const double& dKb2, const double& dRow_cb, const double& dRow_cd);

	void SetParameter(const double& dVCmax_eBL);
	void ExtendedBigLeaf_Vcmax(const double& dCO2, double dLeafTemperature, const double& dPressure, const double& dPPFD, const double& dGPP, const double& dET, const double& dGc, double dGb, const double& dSaturatedLightLevel, double dRd_eBL);

	void Farquhar_BigLeaf_two_leaf(const double& dCO2, const double& dPPFD, const double& dAirTemperature, double dLeafTemperature, 
		const double& dVPD_air, const double& dVP_air, const double& dVP_leaf, const double& dPressure, const double& dGc, double dGb, const double& dTg, const double& dUpscalingFactor,
		double dPPFD_sun, double dPPFD_shade, const double& dFraction_sun, const double& dKb, const double& dLAI,
		const double& dPPFD_direct, const double& dPPFD_diffuse, const double& dKb2, const double& dRow_cb, const double& dRow_cd);
	void Farquhar_BigLeaf_multi_layer(const double& dCO2, const double& dPPFD, const double& dAirTemperature, double dLeafTemperature, 
		const double& dVPD_air, const double& dVP_air, const double& dVP_leaf, const double& dPressure, const double& dGc, double dGb, const double& dTg, const double& dUpscalingFactor,
		double dLAI_sun, double dLAI_shade, 
		const double& dPPFD_direct, const double& dPPFD_diffuse, double dPPFD_sun, double dPPFD_shade, 
		const double& dKb, const double& dKb2, const double& dRow_cb, const double& dRow_cd);

	void radiative_tansfer(const double& dPPFD_direct, const double& dPPFD_diffuse, const double& dLAI, 
		const double& dKb, const double& dKb2, const double& dRow_cb, const double& dRow_cd, const double& dKn, 
		double& dPPFD_sun, double& dPPFD_shade, double& dLAI_sun, double& dWeight_direct);
	void radiative_tansfer(double dPPFD_direct, double dPPFD_diffuse, const double& dPPFD_sun, const double& dPPFD_shade, const double& dLAI, 
		const double& dKb, const double& dKb2, const double& dRow_cb, const double& dRow_cd, const double& dKn,
		std::vector<double>& aryPAR, std::vector<double>& aryPAR_sun, std::vector<double>& aryPAR_shade, std::vector<double>& aryWeight_sun, std::vector<double>& aryVerticalFactor);

	// variables for coupled Farquhar and Ball-Berry model
	double m_dGsc;				//  Stomata Conductance of CO2 (mol m-2 s-1)
	double m_dGsw;				//  Stomata Conductance of H2O (mol m-2 s-1)
	double m_dAn;				//  Leaf Photosynthesis (mol m-2 s-1)	
	double m_dAn_sun;			//  Leaf Photosynthesis by sunlit leaf (mol m-2 s-1)	
	double m_dAn_shade;			//  Leaf Photosynthesis by shaded leaf (mol m-2 s-1)	
	double m_dCi;				//  CO2 Concentration in Leaf (ppm)
	double m_dVCmax;			//  maximum catalytic activity of Rubisco (micro mol m-2 s-1)
	double m_dJmax;				//  maximum electron transport rate (micro mol m-2 s-1)
	double m_dVCmax_sun;		//  maximum catalytic activity of Rubisco by sunlit leaf (micro mol m-2 s-1)
	double m_dJmax_sun;			//  maximum electron transport rate by sunlit leaf (micro mol m-2 s-1)
	double m_dVCmax_shade;		//  maximum catalytic activity of Rubisco by shaded leaf (micro mol m-2 s-1)
	double m_dJmax_shade;		//  maximum electron transport rate by shaded leaf (micro mol m-2 s-1)
	double m_dTranspiration;	//  transpiration (mg m-2 s-1)
	double m_dRd;				//  leaf respiration per unit leaf area (umol m-2 s-1)
	double m_dRd_sun;			//  leaf respiration per unit leaf area (umol m-2 s-1)
	double m_dRd_shade;			//  leaf respiration per unit leaf area (umol m-2 s-1)
	double m_dQstar;			//  absorbed PAR (q*) when leaf photosynthesis is co-limited by Vcmax and Jmax (umol m-2 s-1) (Wang, 2000AFM)
	double m_dA_gs;				// Leaf photosnythesis when stomatal conductance does not limt difussion.
	double m_dA_gs_ga;			// Leaf photosnythesis when stomatal and boundary conductance does not limt difussion.
	double m_dA_gs_ga_ts;		// Leaf photosnythesis when stomatal and boundary conductance does not limt difussion considering leaf temperature.
	double m_dA_gs_sun;			// Leaf photosnythesis when stomatal conductance does not limt difussion by sunlit leaf.
	double m_dA_gs_ga_sun;		// Leaf photosnythesis when stomatal and boundary conductance does not limt difussion by sunlit leaf.
	double m_dA_gs_ga_ts_sun;	// Leaf photosnythesis when stomatal and boundary conductance does not limt difussion considering leaf temperature by sunlit leaf.
	double m_dA_gs_shade;		// Leaf photosnythesis when stomatal conductance does not limt difussion by shaded leaf.
	double m_dA_gs_ga_shade;	// Leaf photosnythesis when stomatal and boundary conductance does not limt difussion by shaded leaf.
	double m_dA_gs_ga_ts_shade;	// Leaf photosnythesis when stomatal and boundary conductance does not limt difussion considering leaf temperature by shaded leaf.
	double m_dAv;				// Rubisco-limited Leaf photosnythesis (umol m-2 s-1)
	double m_dAj;				// Electron-tranport limited Leaf photosnythesis (umol m-2 s-1)

	// variables for extended Big-Leaf model by Kosugi et al., 2005
	double m_dVCmax_eBL;		// extended Big-Leaf Vcmax by Kosugi et al., 2005 (micro mol m-2 s-1)
	double m_dVCmax25_eBL;		// extended Big-Leaf Vcmax by Kosugi et al., 2005 (micro mol m-2 s-1)
	double m_dCi_eBL;			//  CO2 Concentration in Leaf by Kosugi et al., 2005 (ppm)
	double m_dRd_eBL;			// extended Big-Leaf leaf respiration (micro mol m-2 s-1)
	int m_iIteration_eBL;		// iteration for determing leaf respiration

	static int m_iLeuningModel;
	static int m_iPhotosynthesisFunctions;			// 0 : de Pury & Farquhar
	static int m_iC3;								// 1 : C3, 0 : C4
	static int m_iCanopyStructure;					// 0 : Big-Leaf model, 1 : Sun/Shade model
													// 2 : Multi-Layer model (big-leaf), 3 : Multi-Layer model (sun/shade model)
	static int m_iOmegaOptimization;				// 0 : Omega is constant, 1 : Omega changed with optimization 

	static double m_dMultiLayerSplit;		// LAI width of each layer for multi layer model (m2 m-2)
	static double m_dSigma_scattering;		// leaf scattering coefficient
	static double m_dSoilReflectance_ppfd;  // relfectance of soil for PAR
	static double m_dKdd;					// diffuse and scattered diffuse PAR extinction coefficient
	static double m_dOmega;					// clumping factor
	static double m_dKn;					// foliage nitrogen decay coefficient

	double m_dErrorValue;

private:
	double photosynthesis_model_C3(const double& dCO2, double& dVCmax, double& dRd, double& dKc, double& dKo, double& dGanmaStar, double& dJ, const double& dPressure);
	void temperature_response(double& dVCmax, double& dRd, double& dKc, double&  dKo, double& dGanmaStar, double& dJm, double& dJ, double& dTemperature_K, const double& dPPFD, const double& dPressure, const double& dTg, const double& dUpscalingFactor);
	void GanmaStar(double& dGanmaStar, const double& dTemperature_K, const double& dPressure);
	double Arrhenius(const double& k25, const double& Ea, const double& dT);
	double Arrhenius2(const double& k25, const double& dC, const double& dHa, const double& dT);
	double Arrhenius3(const double& k25, const double& dQ10, const double& dT);
	double Arrhenius4(const double& k25, const double& dHa, const double& dT);
	double Inverse_Arrhenius(const double& k, const double& Ea, const double& dT);
	void CubicEquation(double& _An, double& Aa, double& Ea, double& Da, const double& dCO2, double& dGanmaStar, const double& dRhs, const double& dRd, const double& dGb, const double& dPressure);
	void CubicEquation_Baldocchi(double& _An, double& Aa, double& Ea, double& Da, const double& dCO2, double& dGanmaStar, const double& dRhs, const double& dRd, const double& dGb_q, const double& dPressure);

	double Goff_Gratch(const double& dT_degreeC, const double& dPressure);
	double calculate_air_density(const double& dT, const double& dP, const double& dRH, const int& bMol);

	//  Using Farquhar Model
	static const double c_Ganmawc;
	static const double c_Oi;		// oxygen partial pressure (Pa)
	static const double c_kc;		// Michaelis-Menten constant of Rubisco for CO2 (Pa)
	static const double c_ko;		// Michaelis-Menten constant of Rubisco for O2 (Pa)
	static const double c_f;		// spectral correction factor	
	static const double c_sl;		// curvature of leaf response of electron transport to irradiance
	static const double c_S;		// electron-transport temperature response parameter (J K-1 mol-1)
	static const double c_H;		// curvature parameter of Jm (J mol-1)
	static const double c_R;		// Universal gas constant (J mol-1 K-1)
	static const double c_dRatio_Diff_ec;	// Me / Mc = 1.647
	static const double c_dS;		// Co-limiting factor between Av and Aj (Collatz et al., 1991)

	static const double c_dEa_Vl;
	static const double c_dEa_Rl;
	static const double c_dEa_Kc;
	static const double c_dEa_Ko;

	static const double c_dSaturatedRH;

	static const double c_dSpecificHeat;	// specific heat (1004 J K-1 kg -1)
	static const double c_dStefanBoltzman;	// (W m-2 K-4)

	double m_Vcmax25;				// maximum catalytic activity of Rubisco (micro mol m-2 s-1)
	double m_Jmax25;				// maximum electron transport rate at 25oC (micro mol m-2 s-1)
	double m_dBBm;					// m : (none dimensional)
	double m_dBBb;					// b : (mol m-2 s-1)
	double m_dD0;					// vapor pressure deficit at which stomatal conductance reduced to half of the maximum(hPa)

};

#endif // !defined(AFX_LEAFPHOTOSYNTHESIS_H__05A32DE7_A75E_41ED_A806_3C6D57364F83__INCLUDED_)
